# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: C

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    total_rounds = len(my_history) + 1
    cooperation_rate = opp_history.count("C") / len(opp_history) if opp_history else 1.0
    
    # Check for hardcoded opponent strategies
    always_c = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_d = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    
    if always_c:
        return "D"
    if always_d:
        return "D"
    
    # Late-game adjustment
    if total_rounds >= 9:
        recent_defects = opp_history[-5:].count("D") if len(opp_history) >= 5 else 0
        if recent_defects > 2:
            return "D"
    
    # Adaptive Probabilistic Tit-for-Tat
    if cooperation_rate >= 0.6:
        return "C" if random.random() <= 0.8 else "D"
    else:
        return "D" if random.random() <= 0.7 else "C"